/* NAV / MOBILE MENU */
const navToggle = document.getElementById('navToggle');
const navList = document.getElementById('navList');
navToggle?.addEventListener('click', () => {
  const open = navToggle.getAttribute('aria-expanded') === 'true';
  navToggle.setAttribute('aria-expanded', String(!open));
  navList.style.display = open ? 'none' : 'flex';
});

/* SCROLL REVEAL */
const sections = document.querySelectorAll('section');
const revealOnScroll = () => {
  const trigger = window.innerHeight * 0.82;
  sections.forEach(s => {
    const top = s.getBoundingClientRect().top;
    if (top < trigger) s.classList.add('visible');
  });
};
window.addEventListener('scroll', revealOnScroll);
revealOnScroll();

/* LIGHTBOX */
const galleryItems = Array.from(document.querySelectorAll('.gallery-item'));
const lightbox = document.getElementById('lightbox');
const lbImage = document.querySelector('.lb-image');
const lbClose = document.querySelector('.lb-close');
const lbPrev = document.querySelector('.lb-prev');
const lbNext = document.querySelector('.lb-next');
let lbIndex = 0;
function openLightbox(i){
  lbIndex = i;
  lbImage.src = galleryItems[i].src;
  lbImage.alt = galleryItems[i].alt || '';
  lightbox.style.display = 'flex'; lightbox.setAttribute('aria-hidden','false');
}
function closeLightbox(){ lightbox.style.display='none'; lightbox.setAttribute('aria-hidden','true'); }
function nextImage(){ lbIndex = (lbIndex + 1) % galleryItems.length; openLightbox(lbIndex); }
function prevImage(){ lbIndex = (lbIndex - 1 + galleryItems.length) % galleryItems.length; openLightbox(lbIndex); }
galleryItems.forEach((img,i)=> img.addEventListener('click', ()=> openLightbox(i)));
lbClose.addEventListener('click', closeLightbox);
lbNext.addEventListener('click', nextImage);
lbPrev.addEventListener('click', prevImage);
lightbox.addEventListener('click', (e)=> { if(e.target === lightbox) closeLightbox(); });
document.addEventListener('keydown', (e)=> { if(e.key === 'Escape') closeLightbox(); if(e.key==='ArrowRight') nextImage(); if(e.key==='ArrowLeft') prevImage(); });

/* DONATION MODAL + COPY */
const donationModal = document.getElementById('donationModal');
const openDonation = document.getElementById('openDonation');
const closeModal = document.getElementById('closeModal');
const copyBtn = document.getElementById('copyBtn');
const acctNumberEl = document.getElementById('acctNumber');
const floatingGive = document.getElementById('floatingGive');
function showModal(){ donationModal.style.display='flex'; donationModal.setAttribute('aria-hidden','false'); }
function hideModal(){ donationModal.style.display='none'; donationModal.setAttribute('aria-hidden','true'); }
openDonation?.addEventListener('click', showModal);
floatingGive?.addEventListener('click', showModal);
closeModal?.addEventListener('click', hideModal);
donationModal?.addEventListener('click', (e)=> { if (e.target === donationModal) hideModal(); });
copyBtn?.addEventListener('click', ()=>{
  const txt = acctNumberEl?.textContent?.trim();
  if(!txt) return;
  navigator.clipboard?.writeText(txt).then(()=> showToast('Account copied ✅')).catch(()=> showToast('Copy failed', true));
});

/* TOAST */
const toast = document.getElementById('toast');
let toastTimer;
function showToast(msg, err=false){
  toast.textContent = msg;
  toast.style.background = err ? 'crimson' : '#111';
  toast.style.opacity = '1';
  clearTimeout(toastTimer);
  toastTimer = setTimeout(()=>{ toast.style.opacity='0'; }, 3000);
}

/* RIPPLE */
const rippleBtns = document.querySelectorAll('.btn-primary, .floating-give, .theme-toggle, .btn-secondary');
rippleBtns.forEach(btn=>{
  btn.addEventListener('click', (e)=>{
    const circle = document.createElement('span');
    circle.classList.add('ripple');
    btn.appendChild(circle);
    const rect = btn.getBoundingClientRect();
    circle.style.left = (e.clientX - rect.left - 50) + 'px';
    circle.style.top = (e.clientY - rect.top - 50) + 'px';
    setTimeout(()=> circle.remove(), 600);
  });
});

/* TESTIMONIAL SLIDER */
const slides = document.querySelectorAll('.slide');
const prevBtn = document.querySelector('.prev');
const nextBtn = document.querySelector('.next');
let slideIndex = 0;
function showSlide(i){
  slides.forEach(s=> s.classList.remove('active'));
  slides[i].classList.add('active');
}
function nextSlide(){ slideIndex = (slideIndex+1)%slides.length; showSlide(slideIndex); }
function prevSlide(){ slideIndex = (slideIndex-1+slides.length)%slides.length; showSlide(slideIndex); }
nextBtn?.addEventListener('click', nextSlide);
prevBtn?.addEventListener('click', prevSlide);
if(slides.length) { showSlide(slideIndex); let sliderInterval = setInterval(nextSlide, 5500); document.querySelector('.testimonial-slider')?.addEventListener('mouseenter', ()=> clearInterval(sliderInterval)); document.querySelector('.testimonial-slider')?.addEventListener('mouseleave', ()=> sliderInterval = setInterval(nextSlide,5500)); }

/* VERSE CAROUSEL */
const verses = document.querySelectorAll('.verse');
let verseIndex = 0;
function showVerse(i){ verses.forEach(v=> v.classList.remove('active')); verses[i].classList.add('active'); }
function nextVerse(){ verseIndex = (verseIndex+1)%verses.length; showVerse(verseIndex); }
if(verses.length){ showVerse(verseIndex); setInterval(nextVerse, 7000); }

/* CONTACT FORM */
const contactForm = document.getElementById('contactForm');
const sendContact = document.getElementById('sendContact');
sendContact?.addEventListener('click', ()=>{
  const name = document.getElementById('cname').value.trim();
  const email = document.getElementById('cemail').value.trim();
  const msg = document.getElementById('cmessage').value.trim();
  if(!name||!email||!msg){ showToast('Please complete all fields', true); return; }
  document.getElementById('cname').value=''; document.getElementById('cemail').value=''; document.getElementById('cmessage').value='';
  showToast('Message sent — we will reply during service hours');
});

/* VOLUNTEER FORM (feedback) */
const volForm = document.getElementById('volunteerForm');
volForm?.addEventListener('submit',(e)=>{
  showToast('Thank you — your volunteer sign-up was sent');
  // let default submission continue to FormSubmit
});

/* SMOOTH SCROLL FOR NAV */
document.querySelectorAll('a[href^="#"]').forEach(a=>{
  a.addEventListener('click',(e)=>{
    e.preventDefault();
    const id = a.getAttribute('href').slice(1);
    const el = document.getElementById(id);
    if(el) el.scrollIntoView({behavior:'smooth', block:'start'});
    if(window.innerWidth < 900){ navList.style.display='none'; navToggle.setAttribute('aria-expanded','false'); }
  });
});
